unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    Button1: TButton;
    Button2: TButton;
    Edit1: TEdit;
    Label1: TLabel;
    GroupBox2: TGroupBox;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Label2: TLabel;
    Edit2: TEdit;
    Label3: TLabel;
    Edit3: TEdit;
    Button6: TButton;
    Button7: TButton;
    Edit4: TEdit;
    ListBox1: TListBox;
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Edit4KeyPress(Sender: TObject; var Key: Char);
    procedure Button7Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  st:smallint;
  icdev:integer;//handle of reader
  carduid:array[0..128]of char;

implementation
uses rf_unit;

{$R *.dfm}

procedure TForm1.Button2Click(Sender: TObject);
begin
Close();
end;

//link reader
procedure TForm1.Button1Click(Sender: TObject);

begin

if icdev<0 then  begin

icdev:=fw_init(strtoint(Edit1.Text),115200);
if icdev>0 then begin
st := fw_beep(icdev, 10);//beep test
st := fw_config_card(icdev,49);//Set Card Operation type
listbox1.Items.Add('Device link OK');
Button1.Caption:='Unlink';
end else
listBox1.Items.Add('Device link error');

end//if icdev<0 then  begin

else begin
st:=fw_exit(icdev);
if st <>0 then
listBox1.Items.Add('Device Unlink error')
else  begin
listBox1.Items.Add('Device Unlink OK');
icdev:=-1;
Button1.Caption:='Device Link';
end;
end;//else begin

end;

procedure TForm1.FormCreate(Sender: TObject);
begin

icdev:=-1;
st:=-1;

end;

procedure TForm1.Button3Click(Sender: TObject);
begin
listBox1.Items.Clear;
end;

//Find single card
procedure TForm1.Button4Click(Sender: TObject);
var
revlen:Byte;
revbuf:array[0..256]of char;

begin
st:=fw_inventory(icdev,54,0,0,@revlen,carduid);

if st<>0 then
listBox1.Items.Add('Find single card error')
else
listBox1.Items.Add('Find single card success');

end;

//Find multy card
procedure TForm1.Button5Click(Sender: TObject);
var
revlen:Byte;
revbuf:array[0..256]of char;
begin

st:=fw_inventory(icdev,22,0,0,@revlen,revbuf);

if st<>0 then
listBox1.Items.Add('Find multy card error')
else
listBox1.Items.Add('Find multy card success');
end;

//  read data
procedure TForm1.Button6Click(Sender: TObject);
var
revlen:Byte;
revbuf:array[0..256]of char;
sblk:smallint;
blknum:smallint;
i:integer;
str:string;

begin

 //select card
 st:=fw_select_uid(icdev,34,carduid);
 if st<>0 then
 listBox1.Items.Add('fw_select_uid call failed')
else
// listBox1.Items.Add('fw_select_uid call success');

 //make card ready
 st:=fw_reset_to_ready(icdev,34,carduid);
 if st<>0 then
 listBox1.Items.Add('fw_reset_to_ready call error')
 else
// listBox1.Items.Add('fw_reset_to_ready call success');

 //get protection information
 st:=fw_get_securityinfo(icdev,34,4,2,carduid,@revlen,revbuf);
 if st<>0 then
 listBox1.Items.Add('fw_get_securityinfo call error')
 else
// listBox1.Items.Add('fw_get_securityinfo call success');

 //read block
 sblk:=strtoint(Edit2.Text);
 blknum:=strtoint(Edit3.Text);

 st:=fw_readblock(icdev,34,sblk,blknum,carduid,@revlen,revbuf);

 if st<>0 then
 listbox1.Items.Add('read block error')
 else begin
 listbox1.Items.Add('read block success');

 for i:= 0 to blknum-1 do  begin

 str:='BlockAddr: ['+inttostr(i+sblk)+' ],Data: [ '+intToHex(integer(revbuf[i*4]),2)+intToHex(integer(revbuf[i*4+1]),2)+
     intToHex(integer(revbuf[i*4+2]),2)+intToHex(integer(revbuf[i*4+3]),2)+' ]';
 listBox1.Items.Add(str);
 
 end;

 end;


end;

procedure TForm1.Edit4KeyPress(Sender: TObject; var Key: Char);
begin
      if   not   (key   in   ['0'..'9','a'..'f','A'..'F',#13,#8])   then
      Key   :=   #0;

end;

procedure TForm1.Button7Click(Sender: TObject);
var
srvstr:array[0..256]of char;
wbuf:array[0..256]of char;
sblk:smallint;
blknum:smallint;
strLen:integer;
relen:integer  ;


begin

 //select card
 st:=fw_select_uid(icdev,34,carduid);
 if st<>0 then
 listBox1.Items.Add('fw_select_uid called fail')
else
 listBox1.Items.Add('fw_select_uid called success');

 strLen:= length(Edit4.Text);
 //write card
  strpcopy(@srvstr[0],Edit4.text);

  st:= a_hex(wbuf,srvstr,strLen div 2);
  if st <> 0  then
  listBox1.Items.Add('Data error.')
  else
  ;

   //read block

 sblk:=strtoint(Edit2.Text);
 blknum:=strtoint(Edit3.Text);


  //write block
  st:=fw_writeblock(icdev,34,sblk,blknum,carduid,strLen div 2,wbuf);
  if st<>0 then
  listBox1.Items.Add('fw_writeblock called fail')
  else
  listBox1.Items.Add('fw_writeblock called success');

  end;

end.
